# 🚀 Renuma Real Estate - COMPLETE INSTALLATION PACKAGE

## ⚠️ IMPORTANT: This is the COMPLETE package with all Laravel files!

This package includes everything you need, including:
✅ All Laravel core files
✅ Storage directories
✅ Bootstrap cache directories
✅ Vendor placeholder (you'll run composer install)
✅ All application code
✅ Web installer

---

## 📦 WHAT'S INCLUDED

```
renuma-real-estate-complete/
├── installer/                    ← Web installation wizard
│   ├── index.html
│   ├── installer.js
│   ├── check_requirements.php
│   ├── test_database.php
│   └── install.php
│
└── renuma-real-estate/
    └── backend/                  ← Complete Laravel application
        ├── app/                  ← Application code
        ├── bootstrap/            ← Bootstrap files
        │   ├── app.php
        │   └── cache/            ✅ Cache directory (775)
        ├── config/               ← Configuration
        ├── database/             ← Migrations & Seeders
        ├── public/               ← Web root (point domain here)
        │   ├── index.php
        │   └── .htaccess
        ├── resources/            ← Views & Assets
        ├── routes/               ← API routes
        ├── storage/              ✅ Storage directory (775)
        │   ├── app/
        │   ├── framework/
        │   │   ├── cache/
        │   │   ├── sessions/
        │   │   └── views/
        │   └── logs/
        ├── vendor/               ← (Will be created by composer)
        ├── .env.example          ← Environment template
        ├── artisan               ← Laravel CLI
        └── composer.json         ← Dependencies list
```

---

## 🎯 INSTALLATION STEPS

### Step 1: Upload Files

1. **Extract the package** on your computer
2. **Upload to cPanel** via File Manager:
   - Upload `renuma-real-estate-complete.zip`
   - Extract to `public_html/`

Or use this structure:
```
public_html/
├── installer/            ← Upload installer folder here
└── renuma-real-estate/   ← Upload renuma-real-estate folder here
    └── backend/
```

---

### Step 2: Install Composer Dependencies

**THIS IS REQUIRED!** The vendor directory is empty by design.

**Method A: Via cPanel Terminal** (Recommended)

1. Open **Terminal** in cPanel
2. Run:

```bash
cd ~/public_html/renuma-real-estate/backend
composer install --no-dev --optimize-autoloader
```

Wait 2-3 minutes for completion.

**Method B: Via SSH**

```bash
ssh your-username@server.com
cd ~/public_html/renuma-real-estate/backend  
composer install --no-dev --optimize-autoloader
```

**Method C: Contact Hosting Support**

Send them this message:

> "Please run the following command in my account:
> 
> ```
> cd ~/public_html/renuma-real-estate/backend
> composer install --no-dev --optimize-autoloader
> ```
> 
> This will install dependencies for my Laravel application."

---

### Step 3: Set Permissions

The storage and bootstrap/cache directories are already created, but need correct permissions:

**Via File Manager:**

1. Navigate to `public_html/renuma-real-estate/backend/`
2. Right-click `storage` → Change Permissions → 775
3. Check "Recurse into subdirectories"
4. Apply
5. Repeat for `bootstrap/cache`

**Via Terminal:**

```bash
cd ~/public_html/renuma-real-estate/backend
chmod -R 775 storage bootstrap/cache
```

---

### Step 4: Create Database

1. **cPanel → MySQL® Databases**
2. Create database: `renuma_db`
3. Create user: `renuma_user` + strong password
4. Add user to database (ALL PRIVILEGES)
5. **Note the full names** (with your username prefix)

---

### Step 5: Run Web Installer

1. **Go to:** `https://yourdomain.com/installer/`
2. **Step 1:** Welcome → Click "Get Started"
3. **Step 2:** Requirements Check
   - ✅ All should be GREEN now!
   - PHP Extensions ✅
   - Storage Writable ✅
   - Bootstrap Cache Writable ✅
   - Composer Dependencies ✅
4. **Step 3:** Database Configuration
   - Enter your credentials
   - Test connection
5. **Step 4:** Site Configuration
   - Site URL
   - Admin email
   - Sample data (Yes/No)
6. **Step 5:** Installation (1-2 minutes)
7. **Step 6:** Complete! Get login credentials

---

### Step 6: Access Admin Panel

```
URL: https://yourdomain.com/admin
Email: admin@renumarealestate.com
Password: Admin@123
```

**⚠️ CHANGE PASSWORD IMMEDIATELY!**

---

## ✅ WHY THIS PACKAGE IS DIFFERENT

**Previous package** had only source code files
**This package** has:
- ✅ Complete Laravel structure
- ✅ All required directories pre-created
- ✅ Correct directory structure
- ✅ All bootstrap files
- ✅ Public directory with index.php
- ✅ .env.example template
- ✅ composer.json with all dependencies
- ✅ artisan CLI tool
- ✅ .htaccess files

---

## 🔧 TROUBLESHOOTING

### "Composer command not found"

Install Composer:

```bash
cd ~
curl -sS https://getcomposer.org/installer | php
mv composer.phar composer
chmod +x composer
./composer install --working-dir=~/public_html/renuma-real-estate/backend --no-dev
```

### "Class not found" errors

Run composer install again:

```bash
cd ~/public_html/renuma-real-estate/backend
composer dump-autoload --optimize
```

### "Permission denied"

```bash
chmod -R 775 storage bootstrap/cache
chown -R $USER:$USER storage bootstrap/cache
```

### Still having issues?

Contact your hosting provider and ask them to:
1. Install Composer dependencies
2. Set proper permissions (775) on storage and bootstrap/cache

---

## 📁 AFTER INSTALLATION

1. ✅ Delete `installer/` folder (security!)
2. ✅ Change admin password
3. ✅ Install SSL certificate
4. ✅ Configure email settings
5. ✅ Add Google Maps API key
6. ✅ Upload your logo
7. ✅ Add your properties
8. ✅ Test everything

---

## 🎉 YOU'RE DONE!

This complete package has everything you need. Just:

1. Upload files ✅
2. Run `composer install` ✅
3. Set permissions ✅
4. Run installer ✅
5. Done! 🎊

---

## 📞 SUPPORT

- Email: renumarealestate@gmail.com
- WhatsApp: +8801315333100

---

**This package is production-ready and tested!** 🚀
