# 🚀 Renuma Real Estate - Web Installer

## Quick Installation Guide

This web-based installer makes it super easy to deploy Renuma Real Estate on your cPanel hosting.

---

## 📦 What's Included

- ✅ Visual step-by-step installation wizard
- ✅ Automatic system requirements check
- ✅ Database connection testing
- ✅ One-click installation
- ✅ Sample data installation (optional)
- ✅ Complete configuration setup

---

## 🎯 Installation Steps

### Step 1: Upload Files to cPanel

1. Login to your cPanel
2. Go to **File Manager**
3. Navigate to `public_html/`
4. Upload `renuma-real-estate-installer.zip`
5. Extract the ZIP file
6. You should have this structure:
   ```
   public_html/
   ├── installer/          ← Installer files
   ├── backend/            ← Laravel application
   ├── frontend/           ← React application
   └── admin-panel/        ← Admin dashboard
   ```

### Step 2: Create Database in cPanel

1. Go to **MySQL® Databases**
2. Create database: `renuma_db` (will be prefixed with your username)
3. Create user: `renuma_user` with a strong password
4. Add user to database with **ALL PRIVILEGES**
5. **Save your credentials!**

### Step 3: Run the Installer

1. Open your browser
2. Go to: `https://yourdomain.com/installer/`
3. Follow the 6-step wizard:
   - **Step 1**: Welcome - Review features
   - **Step 2**: Requirements - Automatic system check
   - **Step 3**: Database - Enter your credentials
   - **Step 4**: Configuration - Site settings
   - **Step 5**: Installation - Automatic setup (1-2 minutes)
   - **Step 6**: Complete - Get your login credentials

4. **Done!** Your site is ready!

---

## 🔐 Default Login Credentials

After installation:

```
Admin Panel: https://yourdomain.com/admin
Email: admin@renumarealestate.com
Password: Admin@123
```

⚠️ **IMPORTANT**: Change this password immediately after first login!

---

## 📋 System Requirements

The installer will automatically check these requirements:

### Required:
- ✅ PHP 8.1 or higher
- ✅ MySQL 5.7 or higher
- ✅ PHP Extensions: OpenSSL, PDO, Mbstring, Tokenizer, XML, Ctype, JSON, BCMath
- ✅ Writable directories: `storage/`, `bootstrap/cache/`
- ✅ Composer dependencies installed

### Recommended:
- ✅ PHP Memory: 128M or higher
- ✅ Upload Size: 20M or higher
- ✅ Execution Time: 300s or higher
- ✅ GD Extension (for image processing)
- ✅ cURL Extension

---

## 🛠️ Troubleshooting

### "Composer dependencies not found"

**Solution**: Run this command via SSH or cPanel Terminal:
```bash
cd public_html/renuma-real-estate/backend
composer install --no-dev --optimize-autoloader
```

### "Permission denied on storage directory"

**Solution**: Set proper permissions via File Manager:
- Right-click `backend/storage` → Permissions → 775
- Right-click `backend/bootstrap/cache` → Permissions → 775

### "Database connection failed"

**Common Issues**:
1. **Wrong credentials**: Double-check username/password
2. **Missing prefix**: Include cPanel username (e.g., `username_renuma_db`)
3. **Database doesn't exist**: Create it in cPanel → MySQL Databases
4. **User not added**: Make sure user has ALL PRIVILEGES on the database

### "500 Internal Server Error"

**Solutions**:
1. Check PHP version is 8.1+
2. Verify .htaccess file exists in `backend/public/`
3. Check error logs in cPanel
4. Clear browser cache and try again

### Installation gets stuck

**Solution**:
1. Check your server's max_execution_time (should be 300s+)
2. Increase PHP memory_limit to 256M
3. Try running installation again

---

## 📁 File Structure After Installation

```
public_html/
├── installer/                    ← DELETE after installation!
│   ├── index.html
│   ├── installer.js
│   ├── check_requirements.php
│   ├── test_database.php
│   └── install.php
│
├── backend/                      ← Laravel API
│   ├── public/                   ← Point domain here
│   ├── app/
│   ├── database/
│   ├── storage/
│   ├── .env                      ← Your configuration
│   └── ...
│
├── frontend/                     ← Next.js website
│   ├── build/                    ← Upload to main domain
│   └── ...
│
└── admin-panel/                  ← Admin dashboard
    └── ...
```

---

## ⚙️ Post-Installation Configuration

After installation, configure these settings in Admin Panel:

### 1. Email Settings
```
Settings → Email Configuration
- SMTP Host: smtp.gmail.com
- SMTP Port: 587
- Username: your-email@gmail.com
- Password: your-app-password
```

### 2. Google Maps API
```
Settings → API Keys
- Google Maps API Key: your_api_key
```

### 3. Site Settings
```
Settings → General
- Upload Logo
- Site Name
- Contact Information
- Social Media Links
```

### 4. Change Admin Password
```
Profile → Change Password
```

---

## 🔒 Security Recommendations

### After Installation:

1. ✅ **Delete installer directory**
   ```bash
   rm -rf public_html/installer/
   ```

2. ✅ **Change admin password** immediately

3. ✅ **Install SSL certificate** (free via Let's Encrypt in cPanel)

4. ✅ **Set up automatic backups** in cPanel

5. ✅ **Update Laravel** regularly:
   ```bash
   composer update
   ```

6. ✅ **Protect .env file** (already protected by .htaccess)

---

## 🎨 Sample Data Included

If you chose to install sample data, you'll get:

- 🏠 **5 Featured Properties**
  - Luxury Penthouse in Gulshan
  - Modern Apartment in Banani
  - Spacious Villa in Bashundhara
  - Cozy Apartment for Rent
  - Commercial Space in Uttara

- 👔 **4 Professional Agents**
  - Savannah Nguyen (Senior Consultant)
  - Annette Black (Property Specialist)
  - Kathryn Murphy (Luxury Advisor)
  - David Hardson (Real Estate Consultant)

- 📬 **3 Sample Leads** ready for testing

- 📝 **2 Blog Posts** about real estate

- 💬 **3 Client Testimonials**

---

## 🚀 What Works After Installation

✅ Complete property management system
✅ Advanced search and filters
✅ Property listing pages
✅ Agent profiles
✅ Lead capture forms
✅ Email notifications
✅ Admin dashboard with analytics
✅ File upload system
✅ Blog system
✅ Testimonials
✅ WhatsApp integration
✅ Google Maps integration
✅ Mobile responsive design
✅ SEO optimized

---

## 📱 Next Steps

1. **Access Admin Panel**
   - Go to: `https://yourdomain.com/admin`
   - Login with default credentials
   - Change password

2. **Configure Settings**
   - Upload your logo
   - Set up email
   - Add Google Maps key
   - Configure WhatsApp number

3. **Add Your Content**
   - Add your properties
   - Add your agents
   - Customize pages
   - Add blog posts

4. **Deploy Frontend** (Optional)
   - Build Next.js app locally
   - Upload to main domain

5. **Go Live!**
   - Test all features
   - Submit sitemap to Google
   - Start marketing

---

## 🆘 Need Help?

### Documentation
- Full Guide: `CPANEL_DEPLOYMENT_GUIDE.md`
- Quick Start: `QUICK_START_CPANEL.md`
- API Docs: `backend/routes/api.php`

### Support
- 📧 Email: renumarealestate@gmail.com
- 💬 WhatsApp: +8801315333100

### Common Resources
- Laravel Docs: https://laravel.com/docs
- cPanel Docs: https://docs.cpanel.net/
- PHP Docs: https://www.php.net/

---

## 📊 Technical Details

### What the Installer Does:

1. ✅ Checks system requirements
2. ✅ Tests database connection
3. ✅ Creates `.env` configuration file
4. ✅ Generates Laravel application key
5. ✅ Creates all database tables
6. ✅ Seeds sample data (optional)
7. ✅ Creates storage symlink
8. ✅ Sets file permissions
9. ✅ Optimizes Laravel (caches config, routes, views)
10. ✅ Finalizes installation

### Installation Log

After installation, check: `backend/storage/logs/installation.log`

---

## 🎯 Features Overview

### For Property Owners
- List unlimited properties
- Professional property pages
- Lead capture system
- Analytics and insights
- WhatsApp integration

### For Agents
- Agent profiles
- Property assignment
- Lead management
- Performance tracking

### For Admins
- Complete dashboard
- User management
- Content management
- Settings control
- Reports and exports

---

## ⚡ Quick Commands

If you need to run commands manually:

```bash
# Navigate to backend
cd public_html/renuma-real-estate/backend

# Clear all caches
php artisan cache:clear
php artisan config:clear
php artisan route:clear
php artisan view:clear

# Re-optimize
php artisan config:cache
php artisan route:cache
php artisan view:cache

# Create storage link
php artisan storage:link

# Run migrations
php artisan migrate --force

# Seed database
php artisan db:seed --class=DummyDataSeeder --force
```

---

## 🎉 Congratulations!

You've successfully installed Renuma Real Estate!

Your professional property management platform is now ready to:
- Showcase properties beautifully
- Capture and manage leads
- Track performance with analytics
- Scale your real estate business

**Welcome to Renuma Real Estate - "Home of Dreams"! 🏠**

---

## 📄 License

Proprietary - Renuma Real Estate © 2025

---

**Happy Selling! 🎊**
